const fim_char_t * const FIM_DEFAULT_CONFIG_FILE_CONTENTS =
"# $LastChangedDate: 2024-05-15 01:34:42 +0200 (Wed, 15 May 2024) $\n"
"# Contents of the default 'fimrc' file, hardcoded in the fim executable.\n"
"# Read the documentation (man fimrc) to discover how to change this default hardcoded file and how to make your own.\n"
"# Note that usually a ~/.fimrc file is read after these options take effect, so you could reset all of this with ease.\n"
"# Lines beginning with a pound (#) are ignored by fim (they are treated as comments).\n"
"#\n"
"# Internal variables.\n"
"# Some of these variables influence fim's behaviour (input variables), some are set by fim (output variables).\n"
"# It is wise the input variables are set at the beginning of the file, so the bottom may issue commands correctly affected by them.\n"
"if(_cache_control==''){_cache_control='m';}\n"
"if(_debug_commands==''){_debug_commands='';}\n"
"if(_command_expansion==''){_command_expansion=1;}\n"
"if(_display_status==''){_display_status=0;}\n"
"if(_max_cached_images==''){_max_cached_images=5;}\n"
"if(_min_cached_images==''){_min_cached_images=4;}\n"
"if(_max_cached_memory==''){_max_cached_memory=81920;}\n"
"if(_max_iterated_commands==''){_max_iterated_commands=100;}\n"
"if(_want_prefetch==''){_want_prefetch=1;}\n"
"if(_no_external_loader_programs==''){_no_external_loader_programs=0;}\n"
"if(_scale_style==''){_scale_style='b';}\n"
"if(_save_fim_history==''){_save_fim_history=1;}\n"
"if(_load_fim_history==''){_load_fim_history=1;}\n"
"if(_verbose_keys==''){_verbose_keys=0;}\n"
"if(_display_busy==''){_display_busy=1;}\n"
"if(_ignorecase==''){_ignorecase=1;}\n"
"if(_re_search_opts==''){_re_search_opts='biD';}\n"
"if(_console_offset==''){_console_offset=0;}\n"
"if(_console_key==''){_console_key=58;}\n"
"if(_display_as_binary==''){_display_as_binary=0;}\n"
"if(_push_checks==''){_push_checks=1;}\n"
"#if(_want_wm_caption_status==''){_want_wm_caption_status=0;}\n"
"if(_want_exif_orientation==''){_want_exif_orientation=1;}\n"
"if(ascale==''){ascale=\"1.0\";}\n"
"if(_use_mipmaps==''){_use_mipmaps=1;}\n"
"if(_downscale_huge_at_load==''){_downscale_huge_at_load=1;}\n"
"if(_scroll_skip_page_fraction==''){_scroll_skip_page_fraction=0;}\n"
"if(_want_wm_mouse_ctrl==''){_want_wm_mouse_ctrl=\"'pP+a-=nN\";}\n"
"if(_slideshow_sleep_time==''){_slideshow_sleep_time=1;}\n"
"#\n"
"# External variables (not used internally).\n"
"if(allow_round_scroll==''){allow_round_scroll=0;}\n"
"if(console_scroll_n==''){console_scroll_n=3;}\n"
"#\n"
"alias \"toggleautoflip\" \"_autoflip=1-_autoflip\" \"\";\n"
"alias \"toggleautonegate\" \"_autonegate=1-_autonegate\" \"\";\n"
"alias \"toggleflip\" \"i:flipped=1-i:flipped\" \"toggles flipped property on the current image\";\n"
"alias \"flip\" \"toggleflip;redisplay\"        \"flip the current image along the horizontal axis\";\n"
"alias \"fliponce\" \"flip;toggleflip\"         \"flip, but just for one display\";\n"
"alias \"toggleautomirror\" \"_automirror=1-_automirror\" \"\";\n"
"alias \"togglemirror\" \"i:mirrored=1-i:mirrored\" \"toggles mirrored property on the current image\";\n"
"alias \"mirror\" \"togglemirror;redisplay\"         \"mirror the image along the vertical axis\" \"\";\n"
"alias \"mirroronce\" \"mirror;togglemirror\"        \"mirror, but just for one display\";\n"
"alias 'toggleLimitMarked' '__pre_limit_fileindex=_fileindex;_limit_mode=1-_limit_mode; if(_limit_mode==1){limit \"!\";} else { limit; } if(_filelistlen<1){_limit_mode=0;limit;goto __pre_limit_fileindex;} i:fresh=1;redisplay; ' \"toggle between limiting file list to the marked files and the full list\";\n"
"alias \"unlimit\" \"limit;i:fresh=1;reload;redisplay\" \"calling limit with no arguments restores the original list\";\n"
"#alias 'mark_current_file' '_markedfile=i:_filename';\n"
"#alias 'goto_marked_file' 'goto \"?\"._markedfile';\n"
"alias 'mark_current_file' '_markedfile=_fileindex'; # Note: temporary; _markedfile undocumented.\n"
"alias 'goto_marked_file'  'goto _markedfile'; # Note: temporary.\n"
"# Warning : binding to C-s, C-z and C-c won't make effect, as these\n"
"# codes are get caught by the console driver and will have no effect in fim.\n"
"# Moreover, C-z will crash fim and C-c will terminate it.\n"
"# Some other combinations (e.g.:C-l) may have similar problems in your console.\n"
"bind 'f' \"flip\";\n"
"bind 'F' \"fliponce\";\n"
"bind 'm' \"mirror\";\n"
"bind 'M' \"mirroronce\";\n"
"bind 'q'   \"quit\";\n"
"bind 'Esc' \"quit\";\n"
"#bind 'n' \"next_file\";\n"
"#bind 'n' \"next\";\n"
"bind 'C-h' \"help\";\n"
"#bind '?' \"help\"; # assigned to back-search\n"
"#bind '/' \"help\"; # assigned to forward-search\n"
"bind '=' \"scale '100%'\";\n"
"#bind 'p' \"prev_file\";\n"
"#alias 'list_remove_and_reload' \"list 'remove';reload\"; # once menus commands can support ;, remove this\n"
"bind 'Del' \"list 'remove';reload\"; # no quit on last file\n"
"#bind 'Del' \"list_remove_and_reload\"; # no quit on last file\n"
"#bind 'Del' \"if(_filelistlen<2)quit;list 'remove';reload;\"; # quit if no files left\n"
"#bind 's' \"list 'sort'\";\n"
"bind ' ' \"scroll 'forward'\";\n"
"bind 'S' \"toggleDisplayStatus\";\n"
"bind 'I' \"toggleautonegate\";\n"
"bind 'i' \"color 'negate';redisplay\";\n"
"bind 'g' \"color 'desaturate';redisplay\";\n"
"bind '[' 'font_reduce;redisplay';\n"
"bind ']' 'font_magnify;redisplay';\n"
"bind '|' 'toggle_font_auto_scale;redisplay';\n"
"bind '{' 'font \"prev\";redisplay';                                                                                                         \n"
"bind '}' 'font \"next\";redisplay';                                                                                                         \n"
"bind 'G' \"toggleDesaturate\";\n"
"bind 'r' \"rotate90\";\n"
"bind 'R' \"rotate270\";\n"
"bind '+' \"magnify\";\n"
"bind 'a' \"scale 'a'\";\n"
"bind 'H' \"scale 'H'\";\n"
"bind 'Tab'  \"toggleVerbosity\";\n"
"bind 'Menu' \"toggleVerbosity\";\n"
"bind 'v' \"toggleDisplayStatus\";\n"
"bind 'A' \"A\";\n"
"#bind 'C-m' \"list 'mark'\";\n"
"bind 'C-m' \"mark_current_file\";\n"
"bind 'C-j' \"goto_marked_file\";\n"
"bind 'u'   \"list 'unmark'\";\n"
"bind 'Enter' \"list 'mark';goto _lastgotodirection\";\n"
"bind '-' \"reduce\";\n"
"bind \"Up\" \"pan_up\";\n"
"bind 'k' \"pan_up\";\n"
"bind \"Right\" \"pan_right\";\n"
"bind 'l' \"pan_right\";\n"
"bind \"Down\" \"pan_down\";\n"
"bind 'j' \"pan_down\";\n"
"bind \"Left\" \"pan_left\";\n"
"bind 'h' \"pan_left\";\n"
"bind 't' \"align 'top'\";\n"
"bind 'C-g' \"system 'fbgrab' 'fim_'._device_string.'.png'\"; # grab a screenshot\n"
"#bind 'C-r' \"recording 'start'\";\n"
"bind 'C-r' \"reload ''\";\n"
"bind 'Q' \"recording 'stop'\";\n"
"bind 'D' \"recording 'dump'\";\n"
"bind 'E' \"recording 'execute'\";\n"
"bind 'C-e' \"recording 'execute'\";\n"
"bind 'C-x' \"recording 'execute'\";\n"
"bind '.' \"recording 'repeat_last'\";\n"
"bind '`' \"toggleLimitMarked\";\n"
"alias \"toggleVerbosity\" \"_display_console=1-_display_console;i:fresh=1;redisplay\" \"\";\n"
"alias \"toggleKeyVerbosity\" \"_verbose_keys=1-_verbose_keys;redisplay\" \"\";\n"
"alias \"toggleDesaturate\" \"_autodesaturate=1-_autodesaturate;redisplay\" \"\";\n"
"alias \"idempotent_cmd\" \"goto ''\";\n"
"#\n"
"# Autocommands examples:\n"
"#autocmd \"PostInteractiveCommand\" \"fim.png\" \"echo '\\\\nmatched an interactive command on fim.png\\\\n'\";\n"
"#autocmd \"PostDisplay\" \".*png\" \"echo 'this is a png file'\";\n"
"#autocmd \"PostDisplay\" \".*jpg\" \"echo 'this is a jpg file'\";\n"
"#autocmd \"PostDisplay\" \"\" \"echo '\\\\nthis is a file\\\\n'\";\n"
"#autocmd \"PostGoto\"   \"\" \"set_interactive_mode\";\n"
"autocmd \"PostGoto\"      \"\" \"reload\";\n"
"autocmd \"PostWindow\" \"\"   \"i:fresh=1;redisplay;\";\n"
"autocmd \"PreRedisplay\"  \"\" \"i:_will_display=1\";\n"
"autocmd \"PreRedisplay\"  \"\" \"if(_scale_style!='' && i:fresh){i:fresh=0;scale _scale_style ;i:fresh=0;}\";\n"
"autocmd \"PostRedisplay\" \"\"   \"i:_will_display=0\";\n"
"# Display device specific config\n"
"alias \"aalib_fix_do\" \"{if(aascale==''){ascale='2.0';}else{ascale=aascale;} i:fresh=1;display;if(_TERM=~'screen'){echo 'Detected screen+aalib: key bindings may not work as intended.'}}\" \"See aalib_fix.\";\n"
"alias \"aalib_fix\" \"if(_device_string=~'^aa'){aalib_fix_do;scale 'a';}\" \"When using the aalib (ASCII art) library we face a problem: glyph proportions are seldom square (as pixels are), and are tricky to detect; for this reason, we need to reshape the image with respect to the font ratio, but we have to make a guess in the scaling factor to compensate. If at runtime a better value is known for the terminal font height/with ratio, it may be fed in the 'aascale' variable for an accurate scaling.\";\n"
"alias \"cacalib_fix_do\" \"{if(cacascale==''){ascale='1.18';}else{scale=cacascale;} i:fresh=1;display;if(_TERM=~'screen'){echo 'Detected screen+cacalib: key bindings may not work as intended.'}}\" \"See cacalib_fix.\";\n"
"alias \"cacalib_fix\" \"getenv 'DISPLAY';if(_device_string=~'^ca' && ENV_DISPLAY==''){cacalib_fix_do;scale 'a';}\" \"When using the libcaca (Coloured ASCII art) library we face a problem: glyph proportions are seldom square (as pixels are), and are tricky to detect; for this reason, we need to reshape the image with respect to the font ratio, but we have to make a guess in the scaling factor to compensate. If at runtime a better value is known for the terminal font height/with ratio, it may be fed in the 'cacascale' variable for an accurate scaling.\";\n"
"autocmd \"PostReload\"  \"\" \"aalib_fix\";\n"
"autocmd \"PostLoad\"    \"\" \"aalib_fix\";\n"
"autocmd \"PostReload\"  \"\" \"cacalib_fix\";\n"
"autocmd \"PostLoad\"    \"\" \"cacalib_fix\";\n"
"alias \"refresh\" \"desc 'reload';redisplay;\" \"reloads and displays image description\";\n"
"bind \"F5\" \"refresh\";\n"
"alias \"toggle_fullscreen\" \"if( (_device_string=~'^sdl' || _device_string=~'^gtk' ) && !_fullscreen){_old_sw=_screen_width;_old_sh=_screen_height;display 'reinit' 'mW0:0';_fullscreen=1;}else if( (_device_string=~'^sdl' || _device_string=~'^gtk' ) && _old_sw*_old_sh*_fullscreen){display 'reinit' 'rwm'._old_sw.':'._old_sh;_fullscreen=0;}_gtk_fullscreen=_fullscreen;\" \"Toggles full screen. Will show mouse cursor in full screen.\";\n"
"alias \"_gtk_check_for_toggle_fullscreen\" \"if( _device_string=~'^gtk' && _gtk_fullscreen != _fullscreen){toggle_fullscreen;}\";\n"
"alias \"_gtk_check_for_toggle_gtk_menus\" \"if(_device_string=~'^gtk'){if(_hide_gtk_menus){display 'reinit' 'b';}else{display 'reinit' 'B';}}\";\n"
"bind \"F11\" \"toggle_fullscreen\";\n"
"\n"
"autocmd \"PostReload\"  \"\" \"i:fresh=1\" ;\n"
"autocmd \"PostScale\"   \"\" \"if(0==i:_will_display){i:fresh=1;display;}\" ;\n"
"autocmd \"PostPan\"     \"\" \"{i:fresh=1;display;}\" ;\n"
"#autocmd \"PostReload\"   \"pdf|ps|djvu|dvi\" \"scale 'w';align 'top'\";\n"
"autocmd \"PostReload\"   \"\" \"if(i:fresh){redisplay;}\";\n"
"autocmd \"PostInteractiveCommand\"   \"\" \"if(i:fresh){display;i:fresh=0;}\";\n"
"autocmd \"PostInteractiveCommand\"   \"\" \"if(_want_prefetch>0){prefetch;}\";\n"
"autocmd \"PostInteractiveCommand\"   \"\" \"if(_display_console==0 && i:fresh){redisplay;i:fresh=0;}\";\n"
"autocmd \"PostInteractiveCommand\"   \"\" \"idempotent_cmd\"; # Bug workaround: without it console scroll is broken.\n"
"autocmd \"PostInteractiveCommand\"   \"\" \"_gtk_check_for_toggle_gtk_menus;_gtk_check_for_toggle_fullscreen\";\n"
"\n"
"#alias \"next10\" \"i=0;while(i<10){i=i+1;next;display;sleep '1';}\" \"goes forward 10 images\";\n"
"#alias \"prev10\" \"i=0;while(i<10){i=i+1;prev;display;sleep '1';}\" \"goes backward 10 images\";\n"
"bind 'N' \"goto '+1p' '+museum|series|city|category|artist+' '+/S' '+10';\" \"goto by jump or category or directory or just ahead\";\n"
"bind 'P' \"goto '-1p' '-museum|series|city|category|artist+' '-/S' '-10';\" \"goto by jump or category or directory or just back \";\n"
"bind 'C-n' \"goto '+//'\";\n"
"bind 'C-p' \"goto '-//'\";\n"
"bind 'C-b' \"goto '-//'\"; # Warning: many configurations cannot detect C-b.\n"
"bind 'W' \"display 'resize'\" \"if supported, resizes the window to match the current image pixels size\";\n"
"#bind 'C-w' \"scale '100%';display 'resize'\" \"if supported, scales the image to 100% and resizes the window to match its size (if fits)\";\n"
"bind 'C-w' \"if(_scale_style!='w'){_scale_style='w';scale 'w';}else{_scale_style='';scale '100%';}\" \"scale to width\";\n"
"alias \"endless_slideshow\" \"while(1){display;sleep _slideshow_sleep_time;next;}\" \"performs an automated slideshow, endlessly\";\n"
"alias \"bookview\"          \"while(1){display;sleep '2';scroll 'down';}\" \"\";\n"
"alias \"comicview\"         \"while(1){display;sleep '2';scroll 'down';}\" \"\";\n"
"alias \"read\"              \"while(1){display;sleep '2';scroll 'forward';}\" \"\";\n"
"alias \"slowread\"          \"while(_fileindex<=_filelistlen-1){display;sleep '2';scroll 'forward';}\" \"loop once slowly\";\n"
"alias \"fastread\"          \"while(_fileindex<=_filelistlen-1){display;sleep '0.1';scroll 'forward';}\" \"proceeds like in a book but very fast, once\";\n"
"alias \"pornview\"          \"echo 'press any key repeatedly to terminate' ;endless_slideshow\" \"enters an endless slideshow (alias name from an actual image viewer)\";\n"
"autocmd \"PreExecutionCycle\" \"/fbps-\" \"_display_busy=0;_display_status=0\" ;\n"
"autocmd \"PreExecutionCycle\" \"\" \"i:fresh=1;reload\";\n"
"autocmd \"PreExecutionCycle\" \"/fbps-.*ps001.png\" \"i:fresh=1;redisplay\";\n"
"## Example in imposing a file loader to an extension:\n"
"#autocmd \"PreReload\"    \".*mtx.gz\" \"_file_loader='MatrixMarket'\";\n"
"#autocmd \"PostReload\"   \".*mtx.gz\" \"_file_loader=''\";\n"
"bind '*' \"_display_console=0;toggleVerbosity;echo i:*\";\n"
"bind 'w' \"scale 'w'\";\n"
"bind '<' \"rotate10_ccw;display\";\n"
"bind '>' \"rotate10;display\";\n"
"bind '_' \"_scale_style='';scale '100%'\";\n"
"bind ',' \"_display_console=1;echo _last_system_output\";\n"
"bind 'C-a' \"if(_scale_style!='a'){_scale_style='a';scale 'a';}else{_scale_style='';scale '100%';}\" \"scale to height\";\n"
"#\n"
"alias \"pan_nw\" \"pan 'nw'\" \"pans the image to the upper left\";\n"
"alias \"pan_ne\" \"pan 'ne'\" \"pans the image to the upper right\";\n"
"alias \"pan_se\" \"pan 'se'\" \"pans the image to the lower left\";\n"
"alias \"pan_sw\" \"pan 'sw'\" \"pans the image to the lower right\";\n"
"alias \"pan_down\" \"if(_display_console==0){pan 'down';}else{scd;}\" \"pans the image down / scrolls console down\";\n"
"alias \"pan_up\"   \"if(_display_console==0){pan 'up'  ;}else{scu;}\"   \"pans the image up / scrolls console up\";\n"
"alias \"pan_left\" \"pan 'left'\" \"pans the image left\";\n"
"alias \"pan_right\" \"pan 'right'\" \"pans the image right\";\n"
"alias \"diagonal_nw\" \"pan_nw\" \"pans the image to the upper left\";\n"
"alias \"diagonal_ne\" \"pan_ne\" \"pans the image to the upper right\";\n"
"alias \"diagonal_se\" \"pan_se\" \"pans the image to the lower left\";\n"
"alias \"diagonal_sw\" \"pan_sw\" \"pans the image to the lower right\";\n"
"bind 'd' \"diagonal_nw\";\n"
"bind 'D' \"diagonal_se\";\n"
"bind 'x' \"diagonal_ne\";\n"
"bind 'X' \"diagonal_sw\";\n"
"alias \"toggleDisplayStatus\" \"_display_status=1-_display_status;redisplay\" \"\";\n"
"alias \"toggleDisplayBusy\"   \"_display_busy=1-_display_busy\" \"\";\n"
"alias \"sort\" \"list 'sort'\"  \"sorts the files list ordered\";\n"
"bind 'o' \"sort\";\n"
"bind 'b' \"prev\";\n"
"bind 'B' \"toggleDisplayBusy\";\n"
"alias \"random_slideshow\" \"while(1){display;sleep _slideshow_sleep_time; eval 'r=random';goto r;}\" \"performs a shuffled slideshow, endlessly\";\n"
"alias \"rotate90_ccw\" \"i:_orientation=i:_orientation+3;i:fresh=1;redisplay\" \"rotate 90 degrees counter clockwise\";\n"
"alias \"rotate90_cw\"  \"i:_orientation=i:_orientation+1;i:fresh=1;redisplay\" \"rotate 90 degrees clockwise\";\n"
"alias \"rotate180\"  \"i:_orientation=i:_orientation+2;i:fresh=1;redisplay\" \"rotate 180 degrees\";\n"
"alias \"rotate90\" \"rotate90_cw;display\" \"rotate 90 degrees clockwise\";\n"
"alias \"rotate270\" \"rotate90_ccw;display\" \"rotate 90 degrees counter clockwise\";\n"
"alias \"rotate10\"     \"rotate  '10';display\" \"rotate 10 degrees counter clockwise\";\n"
"alias \"rotate10_ccw\" \"rotate -10  ;display\" \"rotate 10 degrees clockwise\";\n"
"\n"
"bind 'K' 'if(_display_console==0){echo i:_filename.\": \".i:_comment;toggleVerbosity}else{toggleVerbosity;}';\n"
"bind 'C-k' 'crop' # still experimental\n"
"\n"
"alias 'cache' 'echo _cache_status' \"displays cached images status\";\n"
"bind 'c' 'align \"center\"';\n"
"alias 'widen'  'i:ascale=i:ascale*\"1.1\";*1.0' \"widen the current image\";\n"
"alias 'narrow' 'i:ascale=i:ascale/\"1.1\";*1.0' \"narrow the current image\";\n"
"bind  'y' \"widen\" \"widen horizontally the image\";\n"
"bind  'Y' \"narrow\" \"shrink horizontally the image\";\n"
"alias 'console_scroll_up' 'if(_console_offset<_console_lines+console_scroll_n-_rows){_console_offset=_console_offset+console_scroll_n;}' \"scrolls up the virtual console\";\n"
"alias 'console_scroll_down' 'if(allow_round_scroll || (_console_offset>=console_scroll_n)){_console_offset=_console_offset-console_scroll_n;}' \"scrolls down the virtual console\";\n"
"alias 'console_scroll_reset' '{_console_offset=0;}';\n"
"alias 'scu'    'console_scroll_up'   \"\";\n"
"alias 'scd'    'console_scroll_down' \"\";\n"
"alias 'scz'    'console_scroll_reset' \"\";\n"
"alias 'center' 'align \"center\"';\n"
"alias 'left'   'align \"left\"';\n"
"alias 'right'  'align \"right\"';\n"
"alias 'top'    'align \"top\"';\n"
"alias 'bottom' 'align \"bottom\"';\n"
"alias \"font_magnify_auto\" \"if(_fbfont_as_screen_fraction>1){_fbfont_as_screen_fraction=_fbfont_as_screen_fraction-1;}else{_fbfont_as_screen_fraction=_screen_width/100+_screen_height/100;}\" \"\";\n"
"alias \"font_magnify_manual\"      \"_fbfont_magnify_factor=_fbfont_magnify_factor+1\" \"\";\n"
"alias \"font_reduce_auto\"  \"if(_fbfont_as_screen_fraction>1){_fbfont_as_screen_fraction=_fbfont_as_screen_fraction+1;}\" \"\";\n"
"alias \"font_reduce_manual\"       \"_fbfont_magnify_factor=_fbfont_magnify_factor-1\" \"\";\n"
"alias \"toggle_font_auto_scale\" \"if(_fbfont_as_screen_fraction<0){_fbfont_as_screen_fraction=0;echo 'Auto font scaling on.';}else{_fbfont_as_screen_fraction=-1;echo 'Auto font scaling off.';}\" \"toggles between manual and auto font scaling control\";\n"
"alias 'next_file_same_search'      \"goto '+//';\" \"go to next file with same search criteria\";\n"
"alias 'next_file_dir_same'      \"goto '+/s';\" \"go to next file in same dir\";\n"
"alias 'next_file_dir_other'     \"goto '+/S';\" \"go to next file in other dir\";\n"
"alias 'next_file_dir_up'        \"goto '+/u';\" \"go to next file up the dir hierarchy\";\n"
"alias 'next_file_dir_down'      \"goto '+/d';\" \"go to next file down the dir hierarchy\";\n"
"alias 'next_file_same_basename' \"goto '+/b';\" \"go to next file with same basename\";\n"
"alias 'prev_file_dir_same'      \"goto '-/s';\" \"go to prev file in same dir\";\n"
"alias 'prev_file_dir_other'     \"goto '-/S';\" \"go to prev file in other dir\";\n"
"alias 'prev_file_dir_up'        \"goto '-/u';\" \"go to prev file up the dir hierarchy\";\n"
"alias 'prev_file_dir_down'      \"goto '-/d';\" \"go to prev file down the dir hierarchy\";\n"
"alias 'prev_file_same_basename' \"goto '-/b';\" \"go to prev file with same basename\";\n"
"#alias \"font_magnify\" \"if(_fbfont_as_screen_fraction<0) {font_magnify_manual;}else{font_magnify_auto;}\" \"increase font size (either relative or absolute)\";\n"
"#alias \"font_reduce\"  \"if(_fbfont_as_screen_fraction<0) {font_reduce_manual;} else{font_reduce_auto;}\"  \"increase font size (either relative or absolute)\";\n"
"alias \"font_magnify\" \"_fbfont_as_screen_fraction=-1;font_magnify_manual\" \"increase absolute font size and set manual font control\";\n"
"alias \"font_reduce\"  \"_fbfont_as_screen_fraction=-1;font_reduce_manual\"  \"decrease absolute font size and set manual font control\";\n"
"bind \"PageUp\" \"if(_display_console==0){prev;}else{scu;}\";\n"
"bind \"PageDown\" \"if(_display_console==0){next;}else{scd;}\";\n"
"bind \"Home\" \"0;\";\n"
"bind \"End\" \"$;\";\n"
"bind \"^\" \"0;\";\n"
"bind \"$\" \"$;\";\n"
"#bind \"Backspace\" \"prev\"; # console code for C-h and Backspace is the same :-)\n"
"bind \"'\" \"goto _lastfileindex.'f'.(_lastpageindex+1).'p'\";\n"
"bind '\"' \"scale 'shadow';i:fresh=1;redisplay;\"; \n"
"bind '(' \"goto '^p'\";\n"
"bind ')' \"goto '$p'\";\n"
"bind 'Z' \"sleep 1\";\n"
"_display_status=1; # lower status line\n"
"_want_wm_caption_status=\"fim:%N@%p%%%L[%i/%l]\";\n"
"_caption_over_image_fmt=\"%?_comment?%:_comment:?\";\n"
"_info_fmt_str=\"%p%% %wx%h%L %i/%l%P %F %T %c\"; # lower right line part\n"
"#_display_status_fmt=\"%N:%k\"; #\n"
"_display_status_fmt=\"%N%?EXIF_DateTimeOriginal?[%:EXIF_DateTimeOriginal:]?%?EXIF_ExposureTime?[%:EXIF_ExposureTime:]?%?EXIF_FNumber?[%:EXIF_FNumber:]?%?EXIF_ApertureValue?[%:EXIF_ApertureValue:]?%?EXIF_ISOSpeedRatings?[ISO%:EXIF_ISOSpeedRatings:]?%?_markedfile?[mark on %:_markedfile:]?:%k\"; # lower left line part\n"
"# funny aliases:\n"
"alias \"webcam\" \"pread 'vgrabbj -d /dev/video0';$\" \"say cheese\";\n"
"alias 'espeak' 'system \\'espeak\\' i:_filename.\" \".i:_comment' 'say something';\n"
"#_fbfont_as_screen_fraction=-1; # disable auto font scaling\n"
"if( _device_string=~'^gtk[^e]*$' ) {\n"
"	alias \"man_fim\"   \"system 'man' 'fim';  _display_console=0;toggleVerbosity;\";\n"
"	alias \"man_fimrc\" \"system 'man' 'fimrc';_display_console=0;toggleVerbosity;\";\n"
"	alias '_rebuild_menus' 'display \"reinit\" \"f\";';\n"
"	alias '_rebuild_quieter_menus' '_debug_commands=_debug_commands-\"m\";display \"reinit\" \"fV\";'; # remove \"m\" occurrences from _debug_commands and rebuild\n"
"	alias '_rebuild_verboser_menus' '_debug_commands=_debug_commands.\"m\";_rebuild_menus;';\n"
"	alias '_rebuild_verbosest_menus' '_debug_commands=_debug_commands.\"mm\";_rebuild_menus;';\n"
"	alias 'toggle_gtk_menus' 'if(!_hide_gtk_menus){_hide_gtk_menus=1;}else{_hide_gtk_menus=0;}';\n"
"	autocmd \"PreInteractiveCommand\"  \"\" \"if(__internal_state_changed){_rebuild_menus;__internal_state_changed=0;}\";\n"
"	autocmd \"PostInteractiveCommand\" \"\" \"if(__internal_state_changed){_rebuild_menus;__internal_state_changed=0;}\";\n"
"	autocmd \"PreExecutionCycle\"      \"\" \"if(__internal_state_changed){_rebuild_menus;__internal_state_changed=0;}\";\n"
"	display \"menuadd\" \n"
"		\"_File/\"\n"
"		\"_File/_Open file  open  C-o\"\n"
"		\"_File/Open _directory  open_dir  \"\n"
"		\"_File/_Next file or page  next  \"\n"
"		\"_File/_Next file  next_file  \"\n"
"		\"_File/_Next in other directory  next_file_dir_other\"\n"
"		\"_File/_Next in this directory  next_file_dir_same\"\n"
"#		\"_File/_Next as last search  goto +\\/\\/  \" # Note that slashes are not supported currently.\n"
"		\"_File/_Next as last search  next_file_same_search  \"\n"
"		\"_File/_Go back to last file  goto _lastfileindex  \"\n"
"		\"_File/_Previous in list  prev  p\"\n"
"#		\"_File/Remove from list  list 'pop'\"\n"
"#		\"_File/Remove from list  list_remove_and_reload  \"\n"
"		\"_File/Remove from list  list 'remove';reload  \"\n"
"		\"_File/Mark  list 'mark'\"\n"
"		\"_File/Unmark  list 'unmark'\"\n"
"		\"_File/_Quit  quit  q\"\n"
"		\"_List/Show  list\"\n"
"		\"_List/_Limit  FimMenuLimit/\"\n"
"		\"_List/Limit to.../files sized as current one  limit '~z'\" # TODO: need a test listing effective menu defs\n"
"		\"_List/Limit to.../files dated as current one  limit '~d'\"\n"
"		\"_List/Limit to.../files with duplicate basename  limit '~='\"\n"
"		\"_List/_Unlimit list (reset)  unlimit  u\"\n"
"		\"_List/Reverse  list 'reverse'  \"\n"
"		\"_List/Sort by name  list 'sort'  \"\n"
"		\"_List/Sort by size  list 'sort_fsize'  \"\n"
"		\"_List/Sort by time  list 'sort_mtime'  \"\n"
"		\"_List/Shuffle randomly  list 'random_shuffle'  \"\n"
"		\"_List/Mark all  list 'markall'  \"\n"
"		\"_List/Slideshow/Random  random_slideshow  \"\n"
"		\"_List/Slideshow/Endless  endless_slideshow  \"\n"
"		\"_List/Slideshow/Slideshow time: 0 s  _slideshow_sleep_time=0    0.5 s  _slideshow_sleep_time=0.5    1 s  _slideshow_sleep_time=1    2 s  _slideshow_sleep_time=2    3 s  _slideshow_sleep_time=3    \"\n"
"		\"_List/Slideshow/Stop  _stop_slideshow=1  \"\n"
"		\"_List/Slideshow/Slow read  slowread  \"\n"
"		\"_List/Slideshow/Fast read  fastread  \"\n"
"		\"_View/  Automirror  toggle||_automirror||1||0  \" # '  ' as external separator, || as internal separator\n"
"		\"_View/||Autoflip||toggle.._autoflip..1..0||\" # || as external separator, .. as internal separator\n"
"#		\"_View/Scale: _auto  _scale_style=a  a  Scale: by _hand (manual)  _scale_style=m  m  Scale: by _width  _scale_style=w  w  Scale: by _height  _scale_style=h  h\"\n"
"		\"_View/**Scale: 1x**_scale_style= ** **Scale: _auto**_scale_style=a**a**Scale: _auto (till 100%)**_scale_style=b**b**Scale: by _hand (manual)**_scale_style=m**m**Scale: by window _width**_scale_style=w**w**Scale: by window _height**_scale_style=h**h\"\n"
"		\"_View/Orientation: normal  _orientation=0    Orientation: 90'right  _orientation=1    Orientation: upside down  _orientation=2    Orientation: 90' left  _orientation=3  \"\n"
"		\"_View/Desaturate  toggle___autodesaturate__1__0  \"\n"
"		\"_View/Autonegate  toggle___autonegate__1__0  \"\n"
"		\"_View/Vertical scroll/** Default steps: auto**_vsteps=****10%**_vsteps=10%****20%**_vsteps=20%****50%**_vsteps=50%****100%**_vsteps=100%**\"\n"
"		\"_View/Vertical scroll/** Skip page fraction if smaller than ...auto**_scroll_skip_page_fraction=****disabled**_scroll_skip_page_fraction=-1****1/8**_scroll_skip_page_fraction=8****1/16**_scroll_skip_page_fraction=16**\"\n"
"		\"_View/Refresh description & co  refresh  \"\n"
"		\"_View/||Apply EXIF Orientation||toggle.._want_exif_orientation..1..0||\"\n"
"		\"_Image/_Mirror  toggle__i:mirrored__1__0  m\"\n"
"		\"_Image/_Flip  toggle&&i:flipped&&1&&0  f\" # && as internal separator\n"
"#		\"_Image Extras/_Let's Flip again  toggle&&i:flipped&&1&&0  f\" # && as internal separator TODO togli\n"
"		\"_Image/Orientation: normal  i:_orientation=0    Orientation: 90'right  i:_orientation=1    Orientation: upside down  i:_orientation=2    Orientation: 90' left  i:_orientation=3  \"\n"
"		\"_Image/EXIF Orientation: normal  i:_exif_orientation=0    EXIF Orientation: 90'right  i:_exif_orientation=1    EXIF Orientation: upside down  i:_exif_orientation=2    EXIF Orientation: 90' left  i:_exif_orientation=3  \" # previously __exif_orientation but renamed for the double-symbol-separator convention\n"
"		\"_Window/_Fullscreen  toggle**_gtk_fullscreen**1**0  F11\"\n"
"		\"_Window/Hide the menu bar (press mouse button to restore)  toggle_gtk_menus\"\n"
"#		\"_Window/Hide menu bar (press mouse button to restore)  toggle||_hide_gtk_menus||0||1\" # not yet ready to replace toggle_gtk_menus\n"
"		\"_Window/Resize window to image size  display 'resize'\"\n"
"		\"_Window/Text size reduce  font_reduce\"\n"
"		\"_Window/Text size magnify  font_magnify\"\n"
"		\"_Window/Text font: next  font 'next'\"\n"
"		\"_Window/Text font: prev  font 'prev'\"\n"
"		\"_Window/Show status line  toggle||_display_status||1||0  \"\n"
"		\"_Window/Caption over image: None  _caption_over_image=0    Caption over image: No background  _caption_over_image=1    Caption over image: Black background  _caption_over_image=2    Caption over image: Above image, no overlap  _caption_over_image=3  \"\n"
"		\"_Window/Window caption: minimal  _want_wm_caption_status=FIM    Window caption: reasonable  _want_wm_caption_status=fim:[%i/%l]    Window caption: rich  _want_wm_caption_status=fim:%N@%p%%%L[%i/%l]%?EXIF_DateTimeOriginal?[%:EXIF_DateTimeOriginal:]?  \"\n"
"		\"_Window/Mouse click help grid: default  _want_wm_mouse_ctrl='pP+a-=nN    Mouse click help grid: simplified  _want_wm_mouse_ctrl=ppp+a-nnn  \"\n"
"		\"_Advanced/Show output console (then hide with Tab)  toggleVerbosity  v\"\n"
"		\"_Advanced/Verbose keys  toggle___verbose_keys__1__0  \"\n"
"		\"_Advanced/Low execution verbosity  _debug_commands=0    Intermediate execution verbosity  _debug_commands=ackCm    High execution verbosity  _debug_commands=ackCmmi  \"\n"
"		\"_Advanced/Rebuild menus with no verbosity  _rebuild_quieter_menus\"\n"
"		\"_Advanced/Rebuild menus with tooltips  _rebuild_verboser_menus\"\n"
"		\"_Advanced/Rebuild menus very verbosely  _rebuild_verbosest_menus\"\n"
"		\"_Advanced/Verbose menu  toggle||_display_busy||1||0\"\n"
"		\"_Advanced/Downscale huge images on load  toggle||_downscale_huge_at_load||1||0\"\n"
"		\"_Advanced/Background prefetch  _want_prefetch=2    Foreground prefetch  _want_prefetch=1    No prefetch  _want_prefetch=0    \"\n"
"		\"_Custom actions/_Mark current file  mark_current_file\"\n"
"		\"_Custom actions/_Go to marked file  goto_marked_file\"\n"
"		\"_Custom actions/Webcam shot (needs vgrabbj)  webcam\"\n"
"		\"_Custom actions/Say something (needs espeak)  espeak\"\n"
"		\"_Custom actions/Max cached memory: 256MiB  _max_cached_memory=262144    unlimited  _max_cached_memory=0    very little  _max_cached_memory=1    80MiB  _max_cached_memory=81920  \"\n"
"		\"_Custom actions/Max cached images: unlimited  _max_cached_images=0    5  _max_cached_images=5    10  _max_cached_images=10    100  _max_cached_images=100  \"\n"
"		\"_All actions/_Commands  FimMenuCommands/\"\n"
"		\"_All actions/_Aliases  FimMenuAliases/\"\n"
"		\"_All actions/_Key Bindings  FimMenuKeyBindings/\"\n"
"		\"_All actions/_Variables  FimMenuVariables/\"\n"
"		\"_Help/_Commands  FimMenuCommandsHelp/\"\n"
"		\"_Help/_Aliases  FimMenuAliasesHelp/\"\n"
"		\"_Help/_Key Bindings  FimMenuKeyBindingsHelp/\"\n"
"		\"_Help/_Variables  FimMenuVariablesHelp/\"\n"
"		\"_Help/_man FIM  man_fim\"\n"
"		\"_Help/_man fimrc  man_fimrc\";\n"
"		#\"_Custom actions/scaling: _auto  _scale_style=a  a  scaling: _auto to original  _scale_style=b  b  scaling: manual  _scale_style=m  m  scaling: by _width  _scale_style=w  w\" # copy for demo purposes\n"
"		#\"_Custom actions/_Toggle flipped flag  toggle__i:flipped__1__0  f\"\n"
"		#\"_Custom actions/_Submenu/_Frobnicate  unmapped_cmd  /\"\n"
"		#\"_Custom actions/_Submenu/_Defrobnicate  unmapped_cmd  u\"\n"
"		#\"_Custom actions/_Submenu/FimMenuLimit  FimMenuLimit/\"\n"
"		#\"_Custom actions/_Submenu/_Do-frobnicate  unmapped_cmd *\" # bad specification\n"
"		#\"_Custom actions/_Submenu/_Fribnikate  frobnicate  unmapped_cmd *\" # bad specification\n"
"		#\"_Custom actions/_Submenu/_Next  next *\" # bad specification\n"
"		#\"_Custom actions/_Add menu...  menu_dialog\"\n"
"		#\"_Custom actions/_Toggle full screen view  toggle		_gtk_fullscreen		1		0\"\n"
"		if (_last_cmd_output!=\"\") quit -1;\n"
"}\n"
"help ''; # WELCOME...\n"
"# More examples:\n"
"#alias \"plisten\" 'popen \"nc -l -p 9999 \"' \"executes fim commands coming from port 9999 on this computer\";\n"
"#alias \"wlisten\" \"while(1){sleep;plisten;}\" \"listen to a pipe, endlessly\";\n"
"#alias \"musicplay\"  \"system 'mpc' 'play'\" \"\";\n"
"#alias \"musicpause\" \"system 'mpc' 'pause'\" \"\";\n"
"#alias \"rdjpgcom\" 'system \"rdjpgcom\" i:_filename';\n"
"# offsetscan usage : need a mechanism for popping all images before.\n"
"#alias \"offsetscan\" \"while(i:width<1){list 'push' 'blob.jpg';stdout _open_offset ;_open_offset=_open_offset+1;reload;}\";\n"
"#alias \"webcam_cycle\" \"while(1){webcam;reload;sleep 1;}\";\n"
"# This is a FIM initialization file. \n"
"# Without it FIM cannot work like it should.\n"
"# Feel free to modify it, but with caution!\n"
"";
