return
{
	cWorld =
	{
		Functions =
		{
			AreCommandBlocksEnabled =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
				},
			},
			BroadcastChat =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Message",
						},
						{
							Type = "cClientHandle",
							Name = "a_Exclude",
						},
						{
							Type = "eMessageType",
							Name = "a_ChatPrefix",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
					Desc = "Retrieves the world height at the specified coords; returns false if chunk not loaded / generated",
				},
				{
					Params =
					{
						{
							Type = "cCompositeChat",
							Name = "a_Message",
						},
						{
							Type = "cClientHandle",
							Name = "a_Exclude",
						},
					},
					Returns =
					{
					},
				},
			},
			BroadcastChatDeath =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Message",
						},
						{
							Type = "cClientHandle",
							Name = "a_Exclude",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			BroadcastChatFailure =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Message",
						},
						{
							Type = "cClientHandle",
							Name = "a_Exclude",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			BroadcastChatFatal =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Message",
						},
						{
							Type = "cClientHandle",
							Name = "a_Exclude",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			BroadcastChatInfo =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Message",
						},
						{
							Type = "cClientHandle",
							Name = "a_Exclude",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			BroadcastChatSuccess =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Message",
						},
						{
							Type = "cClientHandle",
							Name = "a_Exclude",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			BroadcastChatWarning =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Message",
						},
						{
							Type = "cClientHandle",
							Name = "a_Exclude",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			BroadcastEntityAnimation =
			{
				{
					Params =
					{
						{
							Type = "cEntity",
							Name = "a_Entity",
						},
						{
							Type = "EntityAnimation",
							Name = "a_Animation",
						},
						{
							Type = "cClientHandle",
							Name = "a_Exclude",
						},
					},
					Returns =
					{
					},
				},
			},
			BroadcastPlayerListHeaderFooter =
			{
				{
					Params =
					{
						{
							Type = "cCompositeChat",
							Name = "a_Header",
						},
						{
							Type = "cCompositeChat",
							Name = "a_Footer",
						},
					},
					Returns =
					{
					},
				},
			},
			CastThunderbolt =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_Block",
						},
					},
					Returns =
					{
					},
					Desc = "Casts a thunderbolt at the specified coords",
				},
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockY",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
					},
					Returns =
					{
					},
				},
			},
			ChangeWeather =
			{
				{
					Params =
					{
					},
					Returns =
					{
					},
					Desc = "Forces a weather change in the next game tick",
				},
			},
			CreateProjectile =
			{
				{
					Params =
					{
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "cProjectileEntity::eKind",
							Name = "a_Kind",
						},
						{
							Type = "cEntity",
							Name = "a_Creator",
						},
						{
							Type = "cItem",
							Name = "a_Item",
						},
						{
							Type = "Vector3<double>",
							Name = "a_Speed",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Creates a projectile of the specified type. Returns the projectile's UniqueID if successful, cEntity::INVALID_ID otherwise\
	Item parameter is currently used for Fireworks to correctly set entity metadata based on item metadata.",
				},
				{
					Params =
					{
						{
							Type = "double",
							Name = "a_PosX",
						},
						{
							Type = "double",
							Name = "a_PosY",
						},
						{
							Type = "double",
							Name = "a_PosZ",
						},
						{
							Type = "cProjectileEntity::eKind",
							Name = "a_Kind",
						},
						{
							Type = "cEntity",
							Name = "a_Creator",
						},
						{
							Type = "cItem",
							Name = "a_Item",
						},
						{
							Type = "Vector3<double>",
							Name = "a_Speed",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "OBSOLETE, use the Vector3d-based overload instead.\
	Creates a projectile of the specified type. Returns the projectile's UniqueID if successful, cEntity::INVALID_ID otherwise\
	Item parameter is currently used for Fireworks to correctly set entity metadata based on item metadata.",
				},
			},
			DigBlock =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
						{
							Type = "cEntity",
							Name = "a_Digger",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Replaces the specified block with air, and calls the OnBroken block handler.\
	Wakes up the simulators. Doesn't produce pickups, use DropBlockAsPickups() for that instead.\
	Returns true on success, false if the chunk is not loaded.",
				},
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_X",
						},
						{
							Type = "int",
							Name = "a_Y",
						},
						{
							Type = "int",
							Name = "a_Z",
						},
						{
							Type = "cEntity",
							Name = "a_Digger",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "OBSOLETE, use the Vector3-based overload instead.\
	Replaces the specified block with air, and calls the apropriate block handlers (OnBreaking(), OnBroken()).\
	Wakes up the simulators.\
	Doesn't produce pickups, use DropBlockAsPickups() for that instead.\
	Returns true on success, false if the chunk is not loaded.",
				},
			},
			DropBlockAsPickups =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
						{
							Type = "cEntity",
							Name = "a_Digger",
						},
						{
							Type = "cItem",
							Name = "a_Tool",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Digs the specified block, and spawns the appropriate pickups for it.\
	a_Digger is an optional entity causing the digging, usually the player.\
	a_Tool is an optional item used to dig up the block, used by the handlers (empty hand vs shears produce different pickups from leaves).\
	An empty hand is assumed if a_Tool is nullptr.\
	Returns true on success, false if the chunk is not loaded.",
				},
			},
			GenerateChunk =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_ChunkX",
						},
						{
							Type = "int",
							Name = "a_ChunkZ",
						},
					},
					Returns =
					{
					},
					Desc = "Generates the given chunk.",
				},
			},
			GetBiomeAt =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
					},
					Returns =
					{
						{
							Type = "EMCSBiome",
						},
					},
					Desc = "Returns the biome at the specified coords. Reads the biome from the chunk, if loaded, otherwise uses the world generator to provide the biome value",
				},
			},
			GetDataPath =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "const AString",
						},
					},
					Desc = "Returns the data path to the world data",
				},
			},
			GetDefaultWeatherInterval =
			{
				{
					Params =
					{
						{
							Type = "eWeather",
							Name = "a_Weather",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Returns the default weather interval for the specific weather type.\
	Returns -1 for any unknown weather.",
				},
			},
			GetDimension =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "eDimension",
						},
					},
				},
			},
			GetGameMode =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "eGameMode",
						},
					},
					Desc = "Returns the current game mode. Partly OBSOLETE, you should use IsGameModeXXX() functions wherever applicable",
				},
			},
			GetGeneratorQueueLength =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "size_t",
						},
					},
					Desc = "Returns the number of chunks loaded and dirty, and in the lighting queue",
				},
			},
			GetHeight =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Returns the world height at the specified coords; waits for the chunk to get loaded / generated",
				},
			},
			GetIniFileName =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "const AString",
						},
					},
					Desc = "Returns the name of the world.ini file used by this world",
				},
			},
			GetLightingQueueLength =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "size_t",
						},
					},
				},
			},
			GetLinkedEndWorldName =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			GetLinkedNetherWorldName =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			GetLinkedOverworldName =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			GetMapManager =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "cMapManager",
						},
					},
					Desc = "Returns the associated map manager instance.",
				},
			},
			GetMaxCactusHeight =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			GetMaxNetherPortalHeight =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			GetMaxNetherPortalWidth =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			GetMaxSugarcaneHeight =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			GetMaxViewDistance =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			GetMinNetherPortalHeight =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Returns or sets the minumim or maximum netherportal height",
				},
			},
			GetMinNetherPortalWidth =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Returns or sets the minumim or maximum netherportal width",
				},
			},
			GetName =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "const AString",
						},
					},
					Desc = "Returns the name of the world",
				},
			},
			GetNumChunks =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "size_t",
						},
					},
					Desc = "Returns the number of chunks loaded",
				},
			},
			GetNumUnusedDirtyChunks =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "size_t",
						},
					},
					Desc = "Returns the number of unused dirty chunks. That's the number of chunks that we can save and then unload.",
				},
			},
			GetScoreBoard =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "cScoreboard",
						},
					},
					Desc = "Returns the associated scoreboard instance.",
				},
			},
			GetSeed =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Returns the seed of the world.",
				},
			},
			GetSpawnX =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			GetSpawnY =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			GetSpawnZ =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			GetStorageLoadQueueLength =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "size_t",
						},
					},
				},
			},
			GetStorageSaveQueueLength =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "size_t",
						},
					},
				},
			},
			GetTNTShrapnelLevel =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "eShrapnelLevel",
						},
					},
				},
			},
			GetTicksUntilWeatherChange =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			GetWeather =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "eWeather",
						},
					},
					Desc = "Returns the current weather. Instead of comparing values directly to the weather constants, use IsWeatherXXX() functions, if possible",
				},
			},
			GrowPlantAt =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
						{
							Type = "int",
							Name = "a_NumStages",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Grows the plant at the specified position by at most a_NumStages.\
	The block's Grow handler is invoked.\
	Returns the number of stages the plant has grown, 0 if not a plant.",
				},
			},
			GrowRipePlant =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Grows the plant at the specified block to its ripe stage.\
	Returns true if grown, false if not (invalid chunk, non-growable block, already ripe).",
				},
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockY",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
						{
							Type = "bool",
							Name = "a_IsByBonemeal",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "OBSOLETE, use the Vector3-based overload instead.\
	Grows the plant at the specified block to its ripe stage.\
	a_IsByBonemeal is obsolete, do not use.\
	Returns true if grown, false if not (invalid chunk, non-growable block, already ripe).",
				},
			},
			IsBlockDirectlyWatered =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockY",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
				},
			},
			IsDaylightCycleEnabled =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Is the daylight cycle enabled?",
				},
			},
			IsDeepSnowEnabled =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
				},
			},
			IsFarmlandTramplingEnabled =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if farmland trampling is enabled",
				},
			},
			IsGameModeAdventure =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if the world is in Adventure mode",
				},
			},
			IsGameModeCreative =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if the world is in Creative mode",
				},
			},
			IsGameModeSpectator =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if the world is in Spectator mode",
				},
			},
			IsGameModeSurvival =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if the world is in Survival mode",
				},
			},
			IsPVPEnabled =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
				},
			},
			IsSavingEnabled =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Get whether saving chunks is enabled",
				},
			},
			IsSlimeChunk =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_ChunkX",
						},
						{
							Type = "int",
							Name = "a_ChunkZ",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if slimes should spawn in the chunk.",
				},
			},
			IsTrapdoorOpen =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockY",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Is the trapdoor open? Returns false if there is no trapdoor at the specified coords.",
				},
			},
			IsWeatherRain =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if the current weather is rainy.",
				},
			},
			IsWeatherRainAt =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if it is raining at the specified location. This takes into account biomes.",
				},
			},
			IsWeatherStorm =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if the current weather is stormy.",
				},
			},
			IsWeatherStormAt =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if the weather is stormy at the specified location. This takes into account biomes.",
				},
			},
			IsWeatherSunny =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if the current weather is sunny.",
				},
			},
			IsWeatherSunnyAt =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if it is sunny at the specified location. This takes into account biomes.",
				},
			},
			IsWeatherWet =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if the world currently has any precipitation - rain, storm or snow.",
				},
			},
			IsWeatherWetAt =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if it is raining or storming at the specified location.\
	This takes into account biomes.",
				},
			},
			IsWeatherWetAtXYZ =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_Position",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if it is raining or storming at the specified location,\
	and the rain reaches (the bottom of) the specified block position.",
				},
			},
			PickupsFromBlock =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
						{
							Type = "cEntity",
							Name = "a_Digger",
						},
						{
							Type = "cItem",
							Name = "a_Tool",
						},
					},
					Returns =
					{
						{
							Type = "cItems",
						},
					},
					Desc = "Returns all the pickups that would result if the a_Digger dug up the block at a_BlockPos using a_Tool\
	a_Digger is usually a player, but can be nullptr for natural causes.\
	a_Tool is an optional item used to dig up the block, used by the handlers (empty hand vs shears produce different pickups from leaves).\
	An empty hand is assumed if a_Tool is nullptr.\
	Returns an empty cItems object if the chunk is not present.",
				},
			},
			QueueBlockForTick =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockY",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
						{
							Type = "int",
							Name = "a_TicksToWait",
						},
					},
					Returns =
					{
					},
					Desc = "Queues the block to be ticked after the specified number of game ticks",
				},
			},
			QueueSaveAllChunks =
			{
				{
					Params =
					{
					},
					Returns =
					{
					},
					Desc = "Queues a task to save all chunks onto the tick thread. The prefferred way of saving chunks from external sources",
				},
			},
			QueueUnloadUnusedChunks =
			{
				{
					Params =
					{
					},
					Returns =
					{
					},
					Desc = "Queues a task to unload unused chunks onto the tick thread. The prefferred way of unloading.",
				},
			},
			RegenerateChunk =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_ChunkX",
						},
						{
							Type = "int",
							Name = "a_ChunkZ",
						},
					},
					Returns =
					{
					},
					Desc = "Regenerate the given chunk.",
				},
			},
			SendBlockTo =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_X",
						},
						{
							Type = "int",
							Name = "a_Y",
						},
						{
							Type = "int",
							Name = "a_Z",
						},
						{
							Type = "cPlayer",
							Name = "a_Player",
						},
					},
					Returns =
					{
					},
					Desc = "Sends the block at the specified coords to the player.\
	Used mainly when plugins disable block-placing or block-breaking, to restore the previous block.",
				},
			},
			SetAreaBiome =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_MinX",
						},
						{
							Type = "int",
							Name = "a_MaxX",
						},
						{
							Type = "int",
							Name = "a_MinZ",
						},
						{
							Type = "int",
							Name = "a_MaxZ",
						},
						{
							Type = "EMCSBiome",
							Name = "a_Biome",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Sets the biome at the area. Returns true if successful, false if any subarea failed (chunk not loaded).\
	(Re)sends the chunks to their relevant clients if successful.",
				},
				{
					Params =
					{
						{
							Type = "cCuboid",
							Name = "a_Area",
						},
						{
							Type = "EMCSBiome",
							Name = "a_Biome",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Sets the biome at the area. Returns true if successful, false if any subarea failed (chunk not loaded).\
	(Re)sends the chunks to their relevant clients if successful.\
	The cuboid needn't be sorted.",
				},
			},
			SetBiomeAt =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
						{
							Type = "EMCSBiome",
							Name = "a_Biome",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Sets the biome at the specified coords. Returns true if successful, false if not (chunk not loaded).\
	Doesn't resend the chunk to clients, use ForceSendChunkTo() for that.",
				},
			},
			SetChunkAlwaysTicked =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_ChunkX",
						},
						{
							Type = "int",
							Name = "a_ChunkZ",
						},
						{
							Type = "bool",
							Name = "a_AlwaysTicked",
						},
					},
					Returns =
					{
					},
					Desc = "Increments (a_AlwaysTicked == true) or decrements (false) the m_AlwaysTicked counter for the specified chunk.\
	If the m_AlwaysTicked counter is greater than zero, the chunk is ticked in the tick-thread regardless of\
	whether it has any clients or not.\
	This function allows nesting and task-concurrency (multiple separate tasks can request ticking and as long\
	as at least one requests is active the chunk will be ticked).",
				},
			},
			SetCommandBlockCommand =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockY",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
						{
							Type = "AString",
							Name = "a_Command",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
						{
							Type = "AString",
						},
					},
					Desc = "Sets the command block command. Returns true if command changed.",
				},
			},
			SetCommandBlocksEnabled =
			{
				{
					Params =
					{
						{
							Type = "bool",
							Name = "a_Flag",
						},
					},
					Returns =
					{
					},
				},
			},
			SetDaylightCycleEnabled =
			{
				{
					Params =
					{
						{
							Type = "bool",
							Name = "a_IsDaylightCycleEnabled",
						},
					},
					Returns =
					{
					},
					Desc = "Sets the daylight cycle to true / false.",
				},
			},
			SetLinkedEndWorldName =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Name",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			SetLinkedNetherWorldName =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Name",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			SetLinkedOverworldName =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Name",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			SetMaxNetherPortalHeight =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_NewMaxHeight",
						},
					},
					Returns =
					{
					},
				},
			},
			SetMaxNetherPortalWidth =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_NewMaxWidth",
						},
					},
					Returns =
					{
					},
				},
			},
			SetMaxViewDistance =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_MaxViewDistance",
						},
					},
					Returns =
					{
					},
				},
			},
			SetMinNetherPortalHeight =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_NewMinHeight",
						},
					},
					Returns =
					{
					},
				},
			},
			SetMinNetherPortalWidth =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_NewMinWidth",
						},
					},
					Returns =
					{
					},
				},
			},
			SetNextBlockToTick =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
					},
					Returns =
					{
					},
					Desc = "Causes the specified block to be ticked on the next Tick() call.\
	Only one block coord per chunk may be set, a second call overwrites the first call",
				},
			},
			SetSavingEnabled =
			{
				{
					Params =
					{
						{
							Type = "bool",
							Name = "a_IsSavingEnabled",
						},
					},
					Returns =
					{
					},
					Desc = "Set whether saving chunks is enabled",
				},
			},
			SetShouldUseChatPrefixes =
			{
				{
					Params =
					{
						{
							Type = "bool",
							Name = "a_Flag",
						},
					},
					Returns =
					{
					},
				},
			},
			SetSpawn =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_X",
						},
						{
							Type = "int",
							Name = "a_Y",
						},
						{
							Type = "int",
							Name = "a_Z",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Set default spawn at the given coordinates.\
	Returns false if the new spawn couldn't be stored in the INI file.",
				},
			},
			SetTNTShrapnelLevel =
			{
				{
					Params =
					{
						{
							Type = "eShrapnelLevel",
							Name = "a_Flag",
						},
					},
					Returns =
					{
					},
				},
			},
			SetTicksUntilWeatherChange =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_WeatherInterval",
						},
					},
					Returns =
					{
					},
				},
			},
			SetTrapdoorOpen =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockY",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
						{
							Type = "bool",
							Name = "a_Open",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Set the state of a trapdoor. Returns true if the trapdoor was updated, false if there was no trapdoor at those coords.",
				},
			},
			SetWeather =
			{
				{
					Params =
					{
						{
							Type = "eWeather",
							Name = "a_NewWeather",
						},
					},
					Returns =
					{
					},
					Desc = "Sets the specified weather; resets weather interval; asks and notifies plugins of the change",
				},
			},
			ShouldBroadcastAchievementMessages =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
				},
			},
			ShouldBroadcastDeathMessages =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
				},
			},
			ShouldLavaSpawnFire =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
				},
			},
			ShouldUseChatPrefixes =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
				},
			},
			SpawnBoat =
			{
				{
					Params =
					{
						{
							Type = "double",
							Name = "a_X",
						},
						{
							Type = "double",
							Name = "a_Y",
						},
						{
							Type = "double",
							Name = "a_Z",
						},
						{
							Type = "cBoat::eMaterial",
							Name = "a_Material",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
				{
					Params =
					{
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "cBoat::eMaterial",
							Name = "a_Material",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Spawns a boat at the given coordinates.\
	Returns the UniqueID of the spawned boat, or cEntity::INVALID_ID on failure.",
				},
			},
			SpawnEnderCrystal =
			{
				{
					Params =
					{
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "bool",
							Name = "a_ShowBottom",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Spawns a new ender crystal at the specified block coords.\
	Returns the UniqueID of the created entity, or cEntity::INVALID_ID on failure.",
				},
			},
			SpawnExperienceOrb =
			{
				{
					Params =
					{
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "int",
							Name = "a_Reward",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Spawns an experience orb at the given location with the given reward.\
	Returns the UniqueID of the spawned experience orb, or cEntity::INVALID_ID on failure.",
				},
				{
					Params =
					{
						{
							Type = "double",
							Name = "a_X",
						},
						{
							Type = "double",
							Name = "a_Y",
						},
						{
							Type = "double",
							Name = "a_Z",
						},
						{
							Type = "int",
							Name = "a_Reward",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "OBSOLETE, use the Vector3d-based overload instead.\
	Spawns an experience orb at the given location with the given reward.\
	Returns the UniqueID of the spawned experience orb, or cEntity::INVALID_ID on failure.",
				},
			},
			SpawnFallingBlock =
			{
				{
					Params =
					{
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "char",
							Name = "a_BlockType",
						},
						{
							Type = "char",
							Name = "a_BlockMeta",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Spawns an falling block entity at the given position.\
	Returns the UniqueID of the spawned falling block, or cEntity::INVALID_ID on failure.",
				},
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
						{
							Type = "char",
							Name = "a_BlockType",
						},
						{
							Type = "char",
							Name = "a_BlockMeta",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Spawns an falling block entity at the given position.\
	Returns the UniqueID of the spawned falling block, or cEntity::INVALID_ID on failure.",
				},
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_X",
						},
						{
							Type = "int",
							Name = "a_Y",
						},
						{
							Type = "int",
							Name = "a_Z",
						},
						{
							Type = "char",
							Name = "a_BlockType",
						},
						{
							Type = "char",
							Name = "a_BlockMeta",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "OBSOLETE, use the Vector3-based overload instead.\
	Spawns an falling block entity at the given position.\
	Returns the UniqueID of the spawned falling block, or cEntity::INVALID_ID on failure.",
				},
			},
			SpawnItemPickup =
			{
				{
					Params =
					{
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "cItem",
							Name = "a_Item",
						},
						{
							Type = "Vector3<float>",
							Name = "a_Speed",
						},
						{
							Type = "int",
							Name = "a_LifetimeTicks",
						},
						{
							Type = "bool",
							Name = "a_CanCombine",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Spawns a single pickup containing the specified item.",
				},
				{
					Params =
					{
						{
							Type = "double",
							Name = "a_PosX",
						},
						{
							Type = "double",
							Name = "a_PosY",
						},
						{
							Type = "double",
							Name = "a_PosZ",
						},
						{
							Type = "cItem",
							Name = "a_Item",
						},
						{
							Type = "float",
							Name = "a_SpeedX",
						},
						{
							Type = "float",
							Name = "a_SpeedY",
						},
						{
							Type = "float",
							Name = "a_SpeedZ",
						},
						{
							Type = "int",
							Name = "a_LifetimeTicks",
						},
						{
							Type = "bool",
							Name = "a_CanCombine",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "OBSOLETE, use the Vector3d-based overload instead.\
	Spawns a single pickup containing the specified item.",
				},
			},
			SpawnItemPickups =
			{
				{
					Params =
					{
						{
							Type = "cItems",
							Name = "a_Pickups",
						},
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
						{
							Type = "double",
							Name = "a_FlyAwaySpeed",
						},
						{
							Type = "bool",
							Name = "a_IsPlayerCreated",
						},
					},
					Returns =
					{
					},
					Desc = "Spawns item pickups for each item in the list.\
	The initial position of the pickups is at the center of the specified block, with a small random offset.\
	May compress pickups if too many entities.",
				},
				{
					Params =
					{
						{
							Type = "cItems",
							Name = "a_Pickups",
						},
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "double",
							Name = "a_FlyAwaySpeed",
						},
						{
							Type = "bool",
							Name = "a_IsPlayerCreated",
						},
					},
					Returns =
					{
					},
					Desc = "Spawns item pickups for each item in the list.\
	May compress pickups if too many entities.",
				},
				{
					Params =
					{
						{
							Type = "cItems",
							Name = "a_Pickups",
						},
						{
							Type = "double",
							Name = "a_BlockX",
						},
						{
							Type = "double",
							Name = "a_BlockY",
						},
						{
							Type = "double",
							Name = "a_BlockZ",
						},
						{
							Type = "double",
							Name = "a_FlyAwaySpeed",
						},
						{
							Type = "bool",
							Name = "a_IsPlayerCreated",
						},
					},
					Returns =
					{
					},
					Desc = "OBSOLETE, use the Vector3d-based overload instead.\
	Spawns item pickups for each item in the list.\
	May compress pickups if too many entities.",
				},
				{
					Params =
					{
						{
							Type = "cItems",
							Name = "a_Pickups",
						},
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "Vector3<double>",
							Name = "a_Speed",
						},
						{
							Type = "bool",
							Name = "a_IsPlayerCreated",
						},
					},
					Returns =
					{
					},
					Desc = "Spawns item pickups for each item in the list. May compress pickups if too many entities. All pickups get the speed specified.",
				},
				{
					Params =
					{
						{
							Type = "cItems",
							Name = "a_Pickups",
						},
						{
							Type = "double",
							Name = "a_BlockX",
						},
						{
							Type = "double",
							Name = "a_BlockY",
						},
						{
							Type = "double",
							Name = "a_BlockZ",
						},
						{
							Type = "double",
							Name = "a_SpeedX",
						},
						{
							Type = "double",
							Name = "a_SpeedY",
						},
						{
							Type = "double",
							Name = "a_SpeedZ",
						},
						{
							Type = "bool",
							Name = "a_IsPlayerCreated",
						},
					},
					Returns =
					{
					},
					Desc = "OBSOLETE, use the Vector3d-based overload instead.\
	Spawns item pickups for each item in the list. May compress pickups if too many entities. All pickups get the speed specified.",
				},
			},
			SpawnMinecart =
			{
				{
					Params =
					{
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "int",
							Name = "a_MinecartType",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Spawns an minecart at the given coordinates.\
	Returns the UniqueID of the spawned minecart, or cEntity::INVALID_ID on failure.",
				},
				{
					Params =
					{
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "int",
							Name = "a_MinecartType",
						},
						{
							Type = "cItem",
							Name = "a_Content",
						},
						{
							Type = "int",
							Name = "a_BlockHeight",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
				{
					Params =
					{
						{
							Type = "double",
							Name = "a_X",
						},
						{
							Type = "double",
							Name = "a_Y",
						},
						{
							Type = "double",
							Name = "a_Z",
						},
						{
							Type = "int",
							Name = "a_MinecartType",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "OBSOLETE, use the Vector3d-based overload instead.\
	Spawns an minecart at the given coordinates.\
	Returns the UniqueID of the spawned minecart, or cEntity::INVALID_ID on failure.",
				},
				{
					Params =
					{
						{
							Type = "double",
							Name = "a_X",
						},
						{
							Type = "double",
							Name = "a_Y",
						},
						{
							Type = "double",
							Name = "a_Z",
						},
						{
							Type = "int",
							Name = "a_MinecartType",
						},
						{
							Type = "cItem",
							Name = "a_Content",
						},
						{
							Type = "int",
							Name = "a_BlockHeight",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			SpawnMob =
			{
				{
					Params =
					{
						{
							Type = "double",
							Name = "a_PosX",
						},
						{
							Type = "double",
							Name = "a_PosY",
						},
						{
							Type = "double",
							Name = "a_PosZ",
						},
						{
							Type = "eMonsterType",
							Name = "a_MonsterType",
						},
						{
							Type = "bool",
							Name = "a_Baby",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Spawns a mob of the specified type. Returns the mob's UniqueID if recognized and spawned, cEntity::INVALID_ID otherwise",
				},
			},
			SpawnPrimedTNT =
			{
				{
					Params =
					{
						{
							Type = "double",
							Name = "a_X",
						},
						{
							Type = "double",
							Name = "a_Y",
						},
						{
							Type = "double",
							Name = "a_Z",
						},
						{
							Type = "int",
							Name = "a_FuseTimeInSec",
						},
						{
							Type = "double",
							Name = "a_InitialVelocityCoeff",
						},
						{
							Type = "bool",
							Name = "a_ShouldPlayFuseSound",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "OBSOLETE, use the Vector3d-based overload instead.\
	Spawns experience orbs of the specified total value at the given location. The orbs' values are split according to regular Minecraft rules.\
	Returns an vector of UniqueID of all the orbs.",
				},
				{
					Params =
					{
						{
							Type = "Vector3<double>",
							Name = "a_Pos",
						},
						{
							Type = "int",
							Name = "a_FuseTimeInSec",
						},
						{
							Type = "double",
							Name = "a_InitialVelocityCoeff",
						},
						{
							Type = "bool",
							Name = "a_ShouldPlayFuseSound",
						},
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Spawns a new primed TNT entity at the specified block coords and specified fuse duration.\
	Initial velocity is given based on the relative coefficient provided.\
	Returns the UniqueID of the created entity, or cEntity::INVALID_ID on failure.",
				},
			},
			UseBlockEntity =
			{
				{
					Params =
					{
						{
							Type = "cPlayer",
							Name = "a_Player",
						},
						{
							Type = "int",
							Name = "a_BlockX",
						},
						{
							Type = "int",
							Name = "a_BlockY",
						},
						{
							Type = "int",
							Name = "a_BlockZ",
						},
					},
					Returns =
					{
					},
					Desc = "a_Player is using block entity at [x, y, z], handle that:",
				},
			},
			VillagersShouldHarvestCrops =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
				},
			},
			WakeUpSimulators =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_Block",
						},
					},
					Returns =
					{
					},
					Desc = "Wakes up the simulators for the specified block",
				},
			},
			WakeUpSimulatorsInArea =
			{
				{
					Params =
					{
						{
							Type = "cCuboid",
							Name = "a_Area",
						},
					},
					Returns =
					{
					},
					Desc = "Wakes up the simulators for the specified area of blocks",
				},
			},
		},
	},
}
