return
{
	cPawn =
	{
		Inherits =
		{
			"cEntity",
		},
		Functions =
		{
			AddEntityEffect =
			{
				{
					Params =
					{
						{
							Type = "cEntityEffect::eType",
							Name = "a_EffectType",
						},
						{
							Type = "int",
							Name = "a_EffectDurationTicks",
						},
						{
							Type = "short",
							Name = "a_EffectIntensity",
						},
						{
							Type = "double",
							Name = "a_DistanceModifier",
						},
					},
					Returns =
					{
					},
					Desc = "Applies an entity effect.\
	Checks with plugins if they allow the addition.\
	a_EffectIntensity is the level of the effect (0 = Potion I, 1 = Potion II, etc).\
	a_DistanceModifier is the scalar multiplied to the potion duration (only applies to splash potions).",
				},
			},
			ClearEntityEffects =
			{
				{
					Params =
					{
					},
					Returns =
					{
					},
					Desc = "Removes all currently applied entity effects (used when drinking milk)",
				},
			},
			FindTeleportDestination =
			{
				{
					Params =
					{
						{
							Type = "cWorld",
							Name = "a_World",
						},
						{
							Type = "int",
							Name = "a_HeightRequired",
						},
						{
							Type = "int",
							Name = "a_NumTries",
						},
						{
							Type = "Vector3<double>",
							Name = "a_Destination",
						},
						{
							Type = "Vector3<int>",
							Name = "a_MinBoxCorner",
						},
						{
							Type = "Vector3<int>",
							Name = "a_MaxBoxCorner",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Returns the entity effect, if it is currently applied or nullptr if not.",
				},
				{
					Params =
					{
						{
							Type = "cWorld",
							Name = "a_World",
						},
						{
							Type = "int",
							Name = "a_HeightRequired",
						},
						{
							Type = "int",
							Name = "a_NumTries",
						},
						{
							Type = "Vector3<double>",
							Name = "a_Destination",
						},
						{
							Type = "cBoundingBox",
							Name = "a_BoundingBox",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
				},
				{
					Params =
					{
						{
							Type = "cWorld",
							Name = "a_World",
						},
						{
							Type = "int",
							Name = "a_HeightRequired",
						},
						{
							Type = "int",
							Name = "a_NumTries",
						},
						{
							Type = "Vector3<double>",
							Name = "a_Destination",
						},
						{
							Type = "Vector3<int>",
							Name = "a_Centre",
						},
						{
							Type = "int",
							Name = "a_HalfCubeWidth",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Used by enderman and chorus fruit.\
	Checks for valid destinations in a cube of length 2 * a_HalfCubeWidth centred at a_Centre.\
	Returns true and places destination in a_Destination if successful.\
	Returns false if destination could be found after a_NumTries attempts.\
	Details at: https://minecraft.fandom.com/wiki/Enderman#Teleportation.",
				},
			},
			HasEntityEffect =
			{
				{
					Params =
					{
						{
							Type = "cEntityEffect::eType",
							Name = "a_EffectType",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true, if the entity effect is currently applied.",
				},
			},
			RemoveEntityEffect =
			{
				{
					Params =
					{
						{
							Type = "cEntityEffect::eType",
							Name = "a_EffectType",
						},
					},
					Returns =
					{
					},
					Desc = "Removes a currently applied entity effect.",
				},
			},
		},
	},
}
