return
{
	cClientHandle =
	{
		Functions =
		{
			GetClientBrand =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "const AString",
						},
					},
					Desc = "Returns the client brand received in the MC|Brand plugin message or set by a plugin.",
				},
			},
			GetForgeMods =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "const AStringMap",
						},
					},
					Desc = "Returns the Forge mods installed on the client.",
				},
			},
			GetIPString =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "const AString",
						},
					},
					Desc = "Creates a new client with the specified IP address in its description and the specified initial view distance.",
				},
			},
			GetLocale =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			GetPing =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "short",
						},
					},
				},
			},
			GetPlayer =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "cPlayer",
						},
					},
					Desc = "Sets the IP string that the client is using. Overrides the IP string that was read from the socket.\
	Used mainly by BungeeCord compatibility code.",
				},
			},
			GetProtocolVersion =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Returns the protocol version number of the protocol that the client is talking. Returns zero if the protocol version is not (yet) known.",
				},
			},
			GetRequestedViewDistance =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Returns the view distance that the player request, not the used view distance.",
				},
			},
			GetUniqueID =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
				},
			},
			GetUsername =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "const AString",
						},
					},
					Desc = "Send already known recipes without notification but visible in the recipe book",
				},
			},
			GetViewDistance =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "int",
						},
					},
					Desc = "Returns the view distance that the player currently have.",
				},
			},
			HasPluginChannel =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_PluginChannel",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
						{
							Type = "AString",
						},
					},
				},
			},
			IsForgeClient =
			{
				{
					Params =
					{
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					Desc = "Returns true if the client is modded with Forge.",
				},
			},
			Kick =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Reason",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
					Desc = "Formats the type of message with the proper color and prefix for sending to the client.",
				},
			},
			SendBlockBreakAnim =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_EntityID",
						},
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
						{
							Type = "char",
							Name = "a_Stage",
						},
					},
					Returns =
					{
					},
					Desc = "Called while the client is being ticked from the cServer object",
				},
			},
			SendBlockChange =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
						{
							Type = "char",
							Name = "a_BlockType",
						},
						{
							Type = "char",
							Name = "a_BlockMeta",
						},
					},
					Returns =
					{
					},
				},
			},
			SendBossBarAdd =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_UniqueID",
						},
						{
							Type = "cCompositeChat",
							Name = "a_Title",
						},
						{
							Type = "float",
							Name = "a_FractionFilled",
						},
						{
							Type = "BossBarColor",
							Name = "a_Color",
						},
						{
							Type = "BossBarDivisionType",
							Name = "a_DivisionType",
						},
						{
							Type = "bool",
							Name = "a_DarkenSky",
						},
						{
							Type = "bool",
							Name = "a_PlayEndMusic",
						},
						{
							Type = "bool",
							Name = "a_CreateFog",
						},
					},
					Returns =
					{
					},
				},
			},
			SendBossBarRemove =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_UniqueID",
						},
					},
					Returns =
					{
					},
				},
			},
			SendBossBarUpdateFlags =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_UniqueID",
						},
						{
							Type = "bool",
							Name = "a_DarkenSky",
						},
						{
							Type = "bool",
							Name = "a_PlayEndMusic",
						},
						{
							Type = "bool",
							Name = "a_CreateFog",
						},
					},
					Returns =
					{
					},
				},
			},
			SendBossBarUpdateHealth =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_UniqueID",
						},
						{
							Type = "float",
							Name = "a_FractionFilled",
						},
					},
					Returns =
					{
					},
				},
			},
			SendBossBarUpdateStyle =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_UniqueID",
						},
						{
							Type = "BossBarColor",
							Name = "a_Color",
						},
						{
							Type = "BossBarDivisionType",
							Name = "a_DivisionType",
						},
					},
					Returns =
					{
					},
				},
			},
			SendBossBarUpdateTitle =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_UniqueID",
						},
						{
							Type = "cCompositeChat",
							Name = "a_Title",
						},
					},
					Returns =
					{
					},
				},
			},
			SendCollectEntity =
			{
				{
					Params =
					{
						{
							Type = "cEntity",
							Name = "a_Collected",
						},
						{
							Type = "cEntity",
							Name = "a_Collector",
						},
						{
							Type = "unsigned",
							Name = "a_Count",
						},
					},
					Returns =
					{
					},
				},
			},
			SendDestroyEntity =
			{
				{
					Params =
					{
						{
							Type = "cEntity",
							Name = "a_Entity",
						},
					},
					Returns =
					{
					},
				},
			},
			SendDetachEntity =
			{
				{
					Params =
					{
						{
							Type = "cEntity",
							Name = "a_Entity",
						},
						{
							Type = "cEntity",
							Name = "a_PreviousVehicle",
						},
					},
					Returns =
					{
					},
				},
			},
			SendEditSign =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
					},
					Returns =
					{
					},
				},
			},
			SendEntityAnimation =
			{
				{
					Params =
					{
						{
							Type = "cEntity",
							Name = "a_Entity",
						},
						{
							Type = "EntityAnimation",
							Name = "a_Animation",
						},
					},
					Returns =
					{
					},
				},
			},
			SendHideTitle =
			{
				{
					Params =
					{
					},
					Returns =
					{
					},
				},
			},
			SendLeashEntity =
			{
				{
					Params =
					{
						{
							Type = "cEntity",
							Name = "a_Entity",
						},
						{
							Type = "cEntity",
							Name = "a_EntityLeashedTo",
						},
					},
					Returns =
					{
					},
				},
			},
			SendPlayerListHeaderFooter =
			{
				{
					Params =
					{
						{
							Type = "cCompositeChat",
							Name = "a_Header",
						},
						{
							Type = "cCompositeChat",
							Name = "a_Footer",
						},
					},
					Returns =
					{
					},
				},
			},
			SendResetTitle =
			{
				{
					Params =
					{
					},
					Returns =
					{
					},
				},
			},
			SendResourcePack =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_ResourcePackUrl",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			SendSetRawSubTitle =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_SubTitle",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			SendSetRawTitle =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Title",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			SendSetSubTitle =
			{
				{
					Params =
					{
						{
							Type = "cCompositeChat",
							Name = "a_SubTitle",
						},
					},
					Returns =
					{
					},
				},
			},
			SendSetTitle =
			{
				{
					Params =
					{
						{
							Type = "cCompositeChat",
							Name = "a_Title",
						},
					},
					Returns =
					{
					},
				},
			},
			SendSoundEffect =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_SoundName",
						},
						{
							Type = "double",
							Name = "a_X",
						},
						{
							Type = "double",
							Name = "a_Y",
						},
						{
							Type = "double",
							Name = "a_Z",
						},
						{
							Type = "float",
							Name = "a_Volume",
						},
						{
							Type = "float",
							Name = "a_Pitch",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_SoundName",
						},
						{
							Type = "Vector3<double>",
							Name = "a_Position",
						},
						{
							Type = "float",
							Name = "a_Volume",
						},
						{
							Type = "float",
							Name = "a_Pitch",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			SendThunderbolt =
			{
				{
					Params =
					{
						{
							Type = "Vector3<int>",
							Name = "a_BlockPos",
						},
					},
					Returns =
					{
					},
				},
			},
			SendTitleTimes =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_FadeInTicks",
						},
						{
							Type = "int",
							Name = "a_DisplayTicks",
						},
						{
							Type = "int",
							Name = "a_FadeOutTicks",
						},
					},
					Returns =
					{
					},
				},
			},
			SendUnleashEntity =
			{
				{
					Params =
					{
						{
							Type = "cEntity",
							Name = "a_Entity",
						},
					},
					Returns =
					{
					},
				},
			},
			SetClientBrand =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_ClientBrand",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
					Desc = "Called by the protocol when it receives the MC|Brand plugin message. Also callable by plugins.\
	Simply stores the string value.",
				},
			},
			SetLocale =
			{
				{
					Params =
					{
						{
							Type = "AString",
							Name = "a_Locale",
						},
					},
					Returns =
					{
						{
							Type = "AString",
						},
					},
				},
			},
			SetViewDistance =
			{
				{
					Params =
					{
						{
							Type = "int",
							Name = "a_ViewDistance",
						},
					},
					Returns =
					{
					},
					Desc = "Sets the maximal view distance.",
				},
			},
		},
	},
}
