return
{
	cBlockInfo =
	{
		Functions =
		{
			CanBeTerraformed =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Can a finisher change it?",
				},
			},
			FullyOccupiesVoxel =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Does this block fully occupy its voxel - is it a 'full' block?",
				},
			},
			GetBlockHeight =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "float",
						},
					},
					IsStatic = true,
					Desc = "Block's height.",
				},
			},
			GetHardness =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "float",
						},
					},
					IsStatic = true,
					Desc = "Block's hardness. The greater the value the longer the player needs to break the block.",
				},
			},
			GetLightValue =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "char",
						},
					},
					IsStatic = true,
					Desc = "How much light do the blocks emit on their own?",
				},
			},
			GetSpreadLightFalloff =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "char",
						},
					},
					IsStatic = true,
					Desc = "How much light do the blocks consume?",
				},
			},
			IsClickedThrough =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "a_Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Does the client pretend the block doesn't exist when clicking?\
	For example, digging a fire will hit the block below the fire, so fire is \"clicked through\".",
				},
			},
			IsOneHitDig =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Is a block destroyed after a single hit?\
	Warning: IsOneHitDig does not take into account enchantments / status effects / swim state / floating state\
	and therefore may be incorrect. Only use to check if hardness is 0.\
	If you want to check if a player would instantly mine a_Block use cPlayer::CanInstantlyMine(a_Block)",
				},
			},
			IsPistonBreakable =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Can a piston break this block?",
				},
			},
			IsRainBlocker =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Does this block block the passage of rain?",
				},
			},
			IsSkylightDispersant =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Does this block disperse sky light? (only relevant for transparent blocks)",
				},
			},
			IsSnowable =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
				},
			},
			IsSolid =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Is this block solid (player cannot walk through)?",
				},
			},
			IsTransparent =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Is a block transparent? (https://minecraft.gamepedia.com/Opacity)",
				},
			},
			IsUseableBySpectator =
			{
				{
					Params =
					{
						{
							Type = "char",
							Name = "Block",
						},
					},
					Returns =
					{
						{
							Type = "bool",
						},
					},
					IsStatic = true,
					Desc = "Can a spectator interact with this block?",
				},
			},
		},
	},
}
